
/**
 ******************************************************************************
 *
 * @file        RingBuffer.h
 * @brief       Ring Buffer headfile.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.02
 * @date        2022/09/26
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


#ifndef __RINGBUFFER_H_
#define __RINGBUFFER_H_

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include <stdint.h>
#include <stdbool.h>
#include "MG32x02z_MID.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
typedef struct {
  volatile uint8_t* Storage;
  volatile uint8_t* End;
  volatile uint8_t* Read;
  volatile uint8_t* Write;
  volatile uint16_t Size;
  volatile uint16_t Available;
} RingBufferU8;

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void RingBufferU8_Initial(RingBufferU8* pRing, uint8_t* pStorage, uint16_t Size);
uint16_t RingBufferU8_Available(RingBufferU8* pRing);
uint16_t RingBufferU8_Free(RingBufferU8* pRing);
void RingBufferU8_Clear(RingBufferU8* pRing);

void RingBufferU8_WriteByte(RingBufferU8* pRing, uint8_t Data);
void RingBufferU8_Write(RingBufferU8* pRing, const uint8_t* pBuffer, uint16_t Size);

uint8_t RingBufferU8_ReadByte(RingBufferU8* pRing);
void RingBufferU8_Read(RingBufferU8* pRing, uint8_t* pBuffer, uint16_t Size);
uint8_t RingBufferU8_Peekn(RingBufferU8* pRing, uint16_t i);
uint8_t RingBufferU8_Peek(RingBufferU8* pRing);
uint16_t RingBufferU8_ReadUntil(RingBufferU8* pRing, char* pBuffer, uint16_t Size, uint8_t StopByte);
uint16_t RingBufferU8_ReadLine(RingBufferU8* pRing, char* pBuffer, uint16_t Size);

/* Exported variables --------------------------------------------------------*/
extern __IO uint32_t gIdleCount;

/* Exported functions --------------------------------------------------------*/




#ifdef __cplusplus
}
#endif

#endif


